import {
	POPULATE_DATA_PENDING,
	POPULATE_DATA_SUCCESS,
	POPULATE_ERROR,
	CLEAR_ARTICLE_DATA,
	SET_ACTIVE_CATEGORY,
	POPULATE_CARD_DATA_SUCCESS,
	UPDATE_CATEGORY_SET,
	UPDATE_SETTINGS,
	DISPLAY_SETTINGS,
	PAGINATION_COUNTER,
	PAGINATION_OFFSET,
} from '../actions'

export default function rootReducer(state, action) {
	switch (action.type) {
		case POPULATE_DATA_PENDING:
			return {
				...state,
				isLoading: true,
				error: null,
				displaySettings: false,
			}

		case POPULATE_DATA_SUCCESS:
			return { ...state, isLoading: false, articles: action.articles }

		case POPULATE_ERROR:
			return { ...state, isLoading: false, error: action.error }

		case CLEAR_ARTICLE_DATA:
			return { ...state, articles: [], articleCardData: null }

		case SET_ACTIVE_CATEGORY:
			return {
				...state,
				currentCategory: action.currentCategory,
				previousCategory: action.previousCategory,
			}

		case POPULATE_CARD_DATA_SUCCESS:
			return { ...state, articleCardData: action.articleData }

		case UPDATE_CATEGORY_SET:
			return { ...state, categorySet: action.categorySet }

		case UPDATE_SETTINGS:
			return { ...state, settings: action.settings }

		case DISPLAY_SETTINGS:
			return { ...state, error: null, displaySettings: action.displaySettings }

		case PAGINATION_COUNTER:
			return {
				...state,
				pagination: { ...state.pagination, pages: action.pages },
			}

		case PAGINATION_OFFSET:
			return {
				...state,
				fetchArticles: { ...state.fetchArticles, offset: action.offset },
			}

		default:
			return state
	}
}
