export default {
	error: null,
	articles: [],
	currentCategory: 'nyheter',
	previousCategory: '',
	isLoading: false,
	articleCardData: null,
	pagination: {
		articlesPerPage: {
			mobile: 6,
			desktop: 7,
		},
		pages: 1,
	},
	displaySettings: false,
	settings: {
		localNews: {
			selectedCounties: [],
		},
	},
	fetchArticles: {
		limit: 100,
		offset: 0,
		timeout: 5000,
	},
	categorySet: [
		{
			name: 'nyheter',
			title: 'Siste nytt',
			onlyOneHost: '',
			includeHosts:
				'dagbladet.no,aftenposten.no,vg.no,nrk.no,nettavisen.no,tv2.no,dn.no,' +
				'dagsavisen.no,abcnyheter.no,bt.no,aftenbladet.no,fvn.no,hegnar.no',
			excludeHosts: 'adressa.no',
			includeAnyTags: 'nyheter,okonomi',
			excludeTags: 'sport,underholdning,kjendis,film,musikk,kultur,utenlandske',
		},
		{
			name: 'lokale',
			title: 'Lokale nyheter',
			includeHosts: '',
			includeAnyTags: '',
			excludeTags: '',
		},
		{
			name: 'sport',
			title: 'Sport',
			onlyOneHost: '',
			includeHosts: 'dagbladet.no,nrk.no,vg.no,tv2.no,nettavisen.no,aftenposten.no',
			includeAnyTags: 'sport',
			excludeTags: '',
		},
		{
			name: 'underholdning',
			title: 'Underholdning',
			onlyOneHost: '',
			includeHosts: 'seher.no,tv2.no,vg.no,side2.no,kk.no,nrk.no',
			includeAnyTags: 'underholdning,kjendis,film,musikk,kultur',
			excludeTags: '',
		},
		{
			name: 'utenlandske',
			title: 'Utenlandske',
			onlyOneHost: '',
			includeHosts:
				'cnn.com,washingtonpost.com,theguardian.com,nytimes.com,wsj.com,foxnews.com,' +
				'huffingtonpost.com,independent.co.uk,telegraph.co.uk,scmp.com,spiegel.de,mondediplo.com',
			includeAnyTags: 'nyheter,utenlandske,utenriks',
			excludeTags: '',
		},
	],
	counties: [
		{ name: 'Asker og Bærum', harvester: 'asker og bærum' },
		{ name: 'Aust-Agder', harvester: 'aust agder' },
		{ name: 'Buskerud', harvester: 'buskerud' },
		{ name: 'Finnmark', harvester: 'finnmark' },
		{ name: 'Follo', harvester: 'follo' },
		{ name: 'Hedmark', harvester: 'hedmark' },
		{ name: 'Hordaland', harvester: 'hordaland' },
		{ name: 'Møre og Romsdal', harvester: 'møre og romsdal' },
		{ name: 'Nordland', harvester: 'nordland' },
		{ name: 'Nord-Trøndelag', harvester: 'nord trøndelag' },
		{ name: 'Oppland', harvester: 'oppland' },
		{ name: 'Oslo', harvester: 'oslo' },
		{ name: 'Rogaland', harvester: 'rogaland' },
		{ name: 'Romerike', harvester: 'romerike' },
		{ name: 'Sogn og Fjordane', harvester: 'sogn og fjordane' },
		{ name: 'Sør-Trøndelag', harvester: 'sør trøndelag' },
		{ name: 'Telemark', harvester: 'telemark' },
		{ name: 'Troms', harvester: 'troms' },
		{ name: 'Vest-Agder', harvester: 'vest agder' },
		{ name: 'Vestfold', harvester: 'vestfold' },
		{ name: 'Østfold', harvester: 'østfold' },
	],
}
