/* eslint-disable import/prefer-default-export */

import styled from 'styled-components'
import propTypes from 'prop-types'

import { getVariable, getColor } from '@aller/shiny/src/utils'

export const Link = styled.a`
position:relative;
	display: flex;
	margin: 0;
	line-height: 1.2;
	text-decoration: none;
	cursor: pointer;
	border: 0 none;
	padding: calc(${getVariable('verticalBase')} / 1.5) calc(${getVariable('horizontalBase')} * 2)
		calc(${getVariable('verticalBase')} / 1.5) ${getVariable('horizontalBase')};

	&:hover {
		text-decoration: none;

		h4 {
			text-decoration: underline;

			span {
				text-decoration: none;
			}
		}
	}

	&::after {
		content: '';
		display: ${props => (props.isLast ? 'none' : 'block')};
		height: 0.1rem;
		background: ${getColor('grayTint')};
		width: calc(100% - ${getVariable('horizontalBase')} * 2);
		margin: 0 ${getVariable('horizontalBase')};
		position: absolute;
		bottom: 0;
		left: 0;
	}

	// @media (min-width: ${getVariable('largeWidth')}) {
	// 	padding: calc(${getVariable('verticalBase')} / 1.5) calc(${getVariable('horizontalBase')} * 2);
	// 	&::after {
	// 		width: calc(100% - ${getVariable('horizontalBase')} * 4);
	// 		margin: 0 calc(${getVariable('horizontalBase')} * 2);
	// 	}
	// }
`

Link.propTypes = {
	isLink: propTypes.bool,
}

export const Time = styled.span`
	color: ${getColor('typeLight')};
	margin-top: 0.2rem;
	display: block;
	white-space: nowrap;
	min-width: calc(${getVariable('horizontalBase')} * 2);
	font-size: ${getVariable('uiSmallSize')};
	white-space: nowrap;
`

export const Content = styled.h4`
	display: inline-block;
	margin-left: 1rem;
	color: ${getColor('darkness', 'light')};
	font-weight: 700;
	display: inline;
`

export const Source = styled.span`
	color: ${getColor('typeLight')};
	font-weight: normal;
	font-size: ${getVariable('uiSmallSize')};
	margin-left: 0.8rem;
	display: inline;
	background: ${getColor('transparent')};
`
