import React from 'react'
import propTypes from 'prop-types'

import { ButtonContainer, PaginationButton } from './styles/sideways-pagination'

const SidewaysPagination = ({ onMoreClick, onLessClick, hidden, isEnd, isFirst }) => {
	if (hidden) {
		return null
	}

	return (
		<ButtonContainer>
			<PaginationButton onClick={onLessClick} disabled={isFirst} active={!isFirst}>
				Forrige
			</PaginationButton>
			<PaginationButton onClick={onMoreClick} disabled={isEnd} active={!isEnd}>
				Neste
			</PaginationButton>
		</ButtonContainer>
	)
}

SidewaysPagination.defaultProps = {
	hidden: false,
	isEnd: false,
	isFirst: false,
}

SidewaysPagination.propTypes = {
	hidden: propTypes.bool,
	onMoreClick: propTypes.func.isRequired,
	onLessClick: propTypes.func.isRequired,
	isEnd: propTypes.bool,
	isFirst: propTypes.bool,
}

export default SidewaysPagination
