import React from 'react'
import propTypes from 'prop-types'
import { connect } from 'react-redux'
import { bindActionCreators } from 'redux'

import SidewaysPagination from './SidewaysPagination'

import logClick from '../services/log-click'
import { paginationCounter } from '../actions'

class Pagination extends React.Component {
	handleClick = (event, task) => {
		const { settings: { ua: { isDesktop = false } = {} } = {} } = this.context

		const {
			currentCategory,
			pagination: { pages }
		} = this.props
		const {
			actions: { paginationCounter }
		} = this.props
		logClick(`newsstream_pagination_${currentCategory}_${task}_${pages + 1}`)
		paginationCounter(task, isDesktop)
	}

	moreClick = event => {
		const { currentCategory } = this.props
		logClick(`newsstream_pagination_${currentCategory}_next`)
		this.handleClick(event, 'inc')
	}

	lessClick = event => {
		const { currentCategory } = this.props
		logClick(`newsstream_pagination_${currentCategory}_prev`)
		this.handleClick(event, 'dec')
	}

	render() {
		// const { settings: { ua: { isDesktop = false } = {} } = {} } = this.context

		const {
			pagination: { pages },
			displaySettings,
			isLoading
		} = this.props

		return (
			<SidewaysPagination
				displaySettings={displaySettings}
				hidden={isLoading || displaySettings}
				onMoreClick={this.moreClick}
				onLessClick={this.lessClick}
				isFirst={pages === 1}
			/>
		)
	}
}

Pagination.contextTypes = {
	settings: propTypes.shape({
		isTablet: propTypes.bool,
		isDesktop: propTypes.bool
	})
}

Pagination.propTypes = {
	actions: propTypes.shape({
		paginationCounter: propTypes.func.isRequired
	}).isRequired,
	isLoading: propTypes.bool.isRequired,
	pagination: propTypes.shape({
		pages: propTypes.number.isRequired
	}).isRequired,
	displaySettings: propTypes.bool.isRequired,
	currentCategory: propTypes.string.isRequired
}

function mapStateToProps(state) {
	return {
		pagination: state.pagination,
		displaySettings: state.displaySettings,
		isLoading: state.isLoading,
		currentCategory: state.currentCategory
	}
}

function mapDispatchToProps(dispatch) {
	return {
		actions: bindActionCreators(
			{
				paginationCounter
			},
			dispatch
		)
	}
}

export default connect(
	mapStateToProps,
	mapDispatchToProps
)(Pagination)
