import React from 'react'
import propTypes from 'prop-types'
import { LinkBarLink } from '@aller/shiny/src/atoms/LinkBarLink'

import logClick from '../services/log-click'

export default class NewsPaperAllButton extends React.Component {
	handleClick = event => {
		event.preventDefault()
		event.stopPropagation()

		const { setActiveNewsPaperInCategory, currentCategory } = this.props

		logClick(`newsstream_submenu_${currentCategory}_all`)
		setActiveNewsPaperInCategory('')
	}

	render() {
		const { isActive } = this.props

		return (
			<LinkBarLink
				isActive={isActive}
				key="allButton"
				linkText="Alle"
				useUnderline
				onClick={this.handleClick}
				size="large"
			/>
		)
	}
}

NewsPaperAllButton.propTypes = {
	setActiveNewsPaperInCategory: propTypes.func.isRequired,
	isActive: propTypes.bool.isRequired,
	currentCategory: propTypes.string.isRequired
}
