import React from 'react'

import { XavierContext } from '../../store/xavier'
import getHostname from '../../utils/get-hostname'
import Container from './Container'
import CustomCol from './CustomCol'
import Heading from './Heading'
import List from './List'
import ListElement from './ListElement'
import Number from './Number'
import Source from './Source'
import Content from './Content'

const MostRead = () => {
	return (
		<CustomCol md={4}>
			<XavierContext.Consumer>
				{context => (
					<Container>
						<Heading>Mest lest</Heading>
						<List>
							{context.mostRead.slice(0, 5).map((article, i) => {
								return (
									<ListElement target="_blank" className="lp_most_read" href={article.url}>
										<Number>{i + 1}</Number>
										<Content>
											{article.title.length < 77
												? article.title
												: `${article.title.slice(0, 77)}..`}
										</Content>
										<Source>{getHostname(article.url)}</Source>
									</ListElement>
								)
							})}
						</List>
					</Container>
				)}
			</XavierContext.Consumer>
		</CustomCol>
	)
}

export default MostRead
