import throttle from 'lodash.throttle'

function addListener(evt, cb, thr = 100) {
	const throttledCallback = throttle(cb, thr)
	if (document.addEventListener) {
		document.addEventListener(evt, throttledCallback, { passive: true })
	} else if (window.attachEvent) {
		window.attachEvent(`on${evt}`, throttledCallback)
	}
	return throttledCallback
}

export default addListener
