/* eslint-disable max-len */
import React, { useMemo } from 'react'
import { ThemeProvider as StyledThemeProvider, createGlobalStyle } from 'styled-components'

import merge from 'deepmerge'
import defaultTheme from '@aller/shiny/src/themes/default-theme'

import { cssReset } from '@aller/shared/utils/css-reset'

/**
 * An extension of styled-component's ThemeProvider.
 *
 * Why do we need this, you might ask? In addition to what we
 * get from styled-components, this ThemeProvider:
 * - deep merges our theme with the default theme
 * - injects our theme's global styles
 */
const ShinyThemeProvider = ({ children, theme }: any) => {
	// Deep merge the chosen theme with our default theme.
	// This way, we can always assume that every property
	// in the default theme will have a value
	// no matter which theme we are using
	const mergedTheme: any = merge(defaultTheme, theme)
	const GlobalStyles = useMemo(() => createGlobalStyle`${cssReset}`, [])

	return (
		<StyledThemeProvider theme={mergedTheme}>
			<>
				<GlobalStyles theme={mergedTheme} />
				{children}
			</>
		</StyledThemeProvider>
	)
}

export { ShinyThemeProvider }
