import React from 'react'
import PropTypes from 'prop-types'

import { themePropTypes } from '@aller/shiny/src/themes/theme-prop-types'

import { ShinyThemeProvider } from '../LoganThemeProvider' // eslint-disable-line import/no-unresolved

import DynamicThemeHeader from '../header/DynamicThemeHeader'
import DynamicThemeFooter from '../footer/DynamicThemeFooter'

const Layout = ({ theme, children }) => {
	const props = { theme }
	return (
		<ShinyThemeProvider theme={theme}>
			<Global
				styles={{
					body: {
						background: getColor('background')(props),
						color: getColor('type')(props),
						fontFamily: getVariable('mainFont')(props),
						fontSize: getVariable('uiRegularSize')(props),
						lineHeight: getVariable('uiRegularLineHeight')(props),
						fontWeight: getVariable('uiWeight')(props),
					},
				}}
			/>
			<DynamicThemeHeader theme={theme} />
			<main>{children}</main>
			<DynamicThemeFooter theme={theme} />
		</ShinyThemeProvider>
	)
}

Layout.propTypes = {
	theme: PropTypes.shape(themePropTypes).isRequired,
	children: PropTypes.node.isRequired,
}

export default Layout
