import React from 'react'
import SixSix from './SixSix'
import FourFourFour from './FourFourFour'
import Feature from './Feature'

import { Article } from '../../graphql/types'

interface Props {
	articles: Article[]
}

const TopRow = ({ articles = [] }: Props) => {
	switch (articles.length) {
		case 1:
			return <Feature type="tall" articles={articles} loading="eager" />
		case 2:
			return <SixSix type="square" articles={articles} loading="eager" />
		case 3:
			return <FourFourFour type="taller" articles={articles} loading="eager" />
		default:
			return null
	}
}

TopRow.whyDidYouRender = true
export default TopRow
