import React from 'react'

import GridRow from '@aller/shared/components/GridRow'
import { useArticles } from '@aller/shared/store/ArticleStore'

import { getImageRatioByTitle } from '../../utils/get-image-ratio-by-title'
import SolPlug from '../SolPlug/Plug/SolPlug'
import { StandardizedArticlePreviewFormat } from '../../utils/standardize-articles/types'

interface Props {
	type?: 'grow'
}

const SixSixCard: React.FC<Props> = ({ type }) => {
	const articles = useArticles(2)

	let adjustedArticles = articles.map(
		(article: StandardizedArticlePreviewFormat): StandardizedArticlePreviewFormat => {
			article.imageRatio = 0.5
			return article
		},
	)

	if (type === 'grow') {
		adjustedArticles = getImageRatioByTitle(adjustedArticles as any, [6, 6])
	}

	if (adjustedArticles.length < 2) return null

	return (
		<GridRow>
			<SolPlug
				{...adjustedArticles[0]}
				column={{
					xs: 12,
					md: 6,
				}}
				linkpulsePersonalizedClass
				colorTheme={adjustedArticles[0].backgroundColor}
			/>
			<SolPlug
				{...adjustedArticles[1]}
				column={{
					xs: 12,
					md: 6,
				}}
				linkpulsePersonalizedClass
				colorTheme={adjustedArticles[0].backgroundColor}
			/>
		</GridRow>
	)
}
;(SixSixCard as any).whyDidYouRender = true

export default SixSixCard
