import React from 'react'
import InstagramEmbed from 'react-instagram-embed'
import { Row } from '@aller/shiny/src/atoms/Row'
import { Col } from '@aller/shiny/src/atoms/Col'

import GridRow from '../GridRow'
import LoganPlug from '../LoganPlug'

interface Props {
	url: string
	articles: Array<any>
	loading?: 'eager' | 'lazy'
}

const columnSize = {
	xs: 12,
	md: 12
}

const Instagram: React.FC<Props> = ({ url, articles, loading }: Props) => {
	return (
		<GridRow>
			<Col xs={6}>
				<InstagramEmbed url={url} />
			</Col>
			<Col xs={6}>
				<Row>
					<LoganPlug
						title={articles[0].title}
						url={articles[0].url}
						baseImageUrl={articles[0].cleanImage}
						ratio={0.5}
						preset={articles[0].preset}
						category={articles[0].secondaryTitle || articles[0].sectionTag}
						loading={loading}
						column={columnSize}
					/>
					<LoganPlug
						title={articles[1].title}
						url={articles[1].url}
						category={articles[1].secondaryTitle || articles[1].sectionTag}
						baseImageUrl={articles[1].cleanImage}
						ratio={0.5}
						preset={articles[1].preset}
						loading={loading}
						column={columnSize}
					/>
				</Row>
			</Col>
		</GridRow>
	)
}

export default Instagram
