import React from 'react'
import GridRow from '@aller/shared/components/GridRow'
import { useArticles } from '@aller/shared/store/ArticleStore'


import { getImageRatioByTitle } from '../../utils/get-image-ratio-by-title'
import SolPlug from '../SolPlug/Plug/SolPlug'
import { StandardizedArticlePreviewFormat } from '../../utils/standardize-articles/types'

interface Props {
	type?: 'grow'
	variant: 0 | 1
}

const FiveSevenCard: React.FC<Props> = ({ type, variant }) => {
	const articles = useArticles(2)

	let adjustedArticles = articles.map(
		(article: StandardizedArticlePreviewFormat): StandardizedArticlePreviewFormat => {
			article.imageRatio = 0.5
			return article
		},
	)

	const variants = [[5, 7], [7, 5]]

	if (type === 'grow') {
		adjustedArticles = getImageRatioByTitle(adjustedArticles as any, [
			variants[variant][0],
			variants[variant][1],
		])
	}

	if (adjustedArticles.length < 2) return null

	return (
		<GridRow>
			<SolPlug
				{...adjustedArticles[0]}
				column={{
					xs: 12,
					md: variants[variant][0],
				}}
				linkpulsePersonalizedClass
				colorTheme={adjustedArticles[0].backgroundColor}
			/>
			<SolPlug
				{...adjustedArticles[1]}
				column={{
					xs: 12,
					md: variants[variant][1],
				}}
				linkpulsePersonalizedClass
				colorTheme={adjustedArticles[1].backgroundColor}
			/>
		</GridRow>
	)
}
;(FiveSevenCard as any).whyDidYouRender = true

export default FiveSevenCard
