import React from 'react'
import GridRow from '../GridRow'
import LoganPlug from '../LoganPlug'

import { Article } from '../../graphql/types'

interface Props {
	articles: Article[]
	loading?: 'eager' | 'lazy'
	type?: 'tall' | 'square' | 'taller'
}

const Feature: React.FC<Props> = ({ articles, type, loading = 'lazy' }) => {
	let ratio = 0.5

	if (type === 'taller') {
		ratio = 1.3
	}

	if (type === 'tall') {
		ratio = 0.75
	}

	if (type === 'square') {
		ratio = 1
	}

	const {
		cleanImage,
		secondaryTitle,
		sectionTag,
		...rest
	} = articles[0]

	return (
		<GridRow>
			<LoganPlug
				type="giga"
				baseImageUrl={cleanImage}
				loading={loading}
				ratio={ratio}
				category={secondaryTitle || sectionTag}
				column={{
					xs: 12
				}}
				{...rest}
			/>
		</GridRow>
	)
}
;(Feature as any).whyDidYouRender = true

export default Feature
