import React from 'react'
import GridRow from '@aller/shared/components/GridRow'
import { useArticles } from '@aller/shared/store/ArticleStore'


import SolPlug from '../SolPlug/Plug/SolPlug'
import XavierContentAd from '@aller/shared/components/LoganAds/XavierContentAd'
import MediumRectangle from '../LoganAds/MediumRectangle'
import { getImageRatioByTitle } from '../../utils/get-image-ratio-by-title'

interface Props {
	type?: 'grow'
	rowStructure: any[]
}

const CustomCardStructure: React.FC<Props> = ({ type, rowStructure }) => {
	const numOfArticles = rowStructure.filter(structure => structure.type === 'article').length
	let articles: any[] = useArticles(numOfArticles)
	if (articles.length < numOfArticles) return null

	articles = articles.map((article: any) => {
		article.ratio = 0.5
		return article
	})

	if (type === 'grow' && articles.length > 0) {
		const widthArray: any[] = []
		rowStructure.forEach(structure => widthArray.push(structure.width))
		articles = getImageRatioByTitle(articles, widthArray)
	}

	const row: any[] = []
	const cloneArticles = [...articles]
	rowStructure.forEach((structure, i) => {
		if (structure.type === 'content') {
			row.push(
				<XavierContentAd
					key={`custom_${structure.type}_${i}`}
					pos={structure.pos}
					switchWith={structure.switchWith}
					column={{
						xs: 12,
						md: structure.width,
					}}
				/>,
			)
		}
		if (structure.type === 'article') {
			const article = cloneArticles.shift()
			row.push(
				<SolPlug
					{...article}
					key={`custom_${structure.type}_${i}`}
					imageRatio={structure.ratio ? structure.ratio : article.imageRatio}
					column={{
						xs: 12,
						md: structure.width,
					}}
					linkpulsePersonalizedClass
					colorTheme={article.backgroundColor}
				/>,
			)
		}
		if (structure.type === 'display') {
			row.push(<MediumRectangle key={`custom_${structure.type}_${i}`} pos={structure.pos} />)
		}
	})

	return <GridRow>{row}</GridRow>
}
;(CustomCardStructure as any).whyDidYouRender = true

export default CustomCardStructure
