import React from 'react'
import ContentLoader from 'react-content-loader'

import Grid from '../FlexGrid'

const FourFourFourLoader = () => (
	<ContentLoader height={334} width={980} speed={2} primaryColor="#f3f3f3" secondaryColor="#ecebeb">
		<rect x="0" y="16" rx="0" ry="0" width="317" height="237" />
		<rect x="0" y="269" rx="0" ry="0" width="180" height="25" />
		<rect x="0" y="310" rx="0" ry="0" width="260" height="40" />

		<rect x="331" y="16" rx="0" ry="0" width="317" height="237" />
		<rect x="331" y="269" rx="0" ry="0" width="200" height="25" />
		<rect x="331" y="310" rx="0" ry="0" width="230" height="40" />

		<rect x="662" y="16" rx="0" ry="0" width="317" height="237" />
		<rect x="662" y="269" rx="0" ry="0" width="230" height="25" />
		<rect x="662" y="310" rx="0" ry="0" width="250" height="40" />
	</ContentLoader>
)

const TopRowLoader: React.FC<{ numberOfArticlesInTopRow: number }> = ({
	numberOfArticlesInTopRow
}) => {
	if (numberOfArticlesInTopRow === 1) {
		return (
			<ContentLoader
				height={840}
				width={980}
				speed={2}
				primaryColor="#f3f3f3"
				secondaryColor="#ecebeb"
			>
				<rect x="0" y="0" rx="0" ry="0" width="980" height="735" />
				<rect x="0" y="751" rx="0" ry="0" width="230" height="25" />
				<rect x="0" y="792" rx="0" ry="0" width="580" height="40" />

				<rect x="497" y="0" rx="0" ry="0" width="483" height="483" />
				<rect x="497" y="499" rx="0" ry="0" width="230" height="25" />
				<rect x="497" y="540" rx="0" ry="0" width="483" height="40" />
				<rect x="497" y="590" rx="0" ry="0" width="400" height="40" />
			</ContentLoader>
		)
	}

	if (numberOfArticlesInTopRow === 2) {
		return (
			<ContentLoader
				height={620}
				width={980}
				speed={2}
				primaryColor="#f3f3f3"
				secondaryColor="#ecebeb"
			>
				<rect x="0" y="0" rx="0" ry="0" width="483" height="483" />
				<rect x="0" y="499" rx="0" ry="0" width="230" height="25" />
				<rect x="0" y="540" rx="0" ry="0" width="483" height="40" />
				<rect x="0" y="590" rx="0" ry="0" width="400" height="40" />

				<rect x="497" y="0" rx="0" ry="0" width="483" height="483" />
				<rect x="497" y="499" rx="0" ry="0" width="230" height="25" />
				<rect x="497" y="540" rx="0" ry="0" width="483" height="40" />
				<rect x="497" y="590" rx="0" ry="0" width="400" height="40" />
			</ContentLoader>
		)
	}

	return <FourFourFourLoader />
}

const MobileLoader = () => (
	<ContentLoader height={480} width={438} speed={2} primaryColor="#f3f3f3" secondaryColor="#ecebeb">
		<rect x="0" y="0" rx="0" ry="0" width="438" height="327" />
		<rect x="0" y="405" rx="0" ry="0" width="230" height="25" />
		<rect x="0" y="337" rx="0" ry="0" width="483" height="56" />
	</ContentLoader>
)

const LoganLoading: React.FC<{ mobile: boolean; numberOfArticlesInTopRow: number }> = ({
	mobile,
	numberOfArticlesInTopRow
}) => {
	if (mobile) {
		return (
			<Grid>
				<MobileLoader />
				<MobileLoader />
				<MobileLoader />
			</Grid>
		)
	}
	return (
		<Grid>
			<TopRowLoader numberOfArticlesInTopRow={numberOfArticlesInTopRow} />
			<FourFourFourLoader />
		</Grid>
	)
}

export default LoganLoading
