import React, { useCallback } from 'react'
import { Button } from '@aller/shiny/src/atoms/Button'

import Col from '../FlexCol'
import Grid from '../FlexGrid'
import Row from '../FlexRow'
import Section from '../Section'

const LoganError = () => {
	const handleClick = useCallback(() => window.location.reload(true), [])
	return (
		<Section>
			<Grid>
				<Row column="xs" center="xs" middle="xs">
					<Col xs={12}>
						<p>Oi, her skjedde det en feil!</p>
					</Col>
					<Col xs={12}>
						<Button primary onClick={handleClick}>
							Prøv på nytt
						</Button>
					</Col>
				</Row>
			</Grid>
		</Section>
	)
}

export default LoganError
