import React from 'react'
import ContentPlug from '@aller/shared/components/SolPlug/Plug/ContentPlug' // eslint-disable-line import/no-extraneous-dependencies, import/no-unresolved
import { useContentAd } from '@aller/shared/providers/XavierProvider' // eslint-disable-line import/no-extraneous-dependencies
import { useIsMobile } from '../../hooks/useIsMobile'
import Banner from './Banner'
import GridRow from '@aller/shared/components/GridRow'
import MediumRectangle from './MediumRectangle'
import Netboard from './Netboard'
import { Column } from '../FlexCol/types'
import TrackingProvider from '../BlinkLabrador/TrackingProvider'

interface DisplayProps {
	pos: number
}

const DisplayAd: React.FC<DisplayProps> = ({ pos, switchWith }) => {
	const mobile = useIsMobile()

	if (mobile) {
		return <Banner pos={pos} slot="ad-banner-perz" />
	}

	if (switchWith === 'netboard') {
		return <Netboard pos={pos} slot="ad-netboard-perz" />
	}

	return <MediumRectangle pos={pos} slot="ad-medium-rectangle-perz" />
}

interface ContentProps {
	data: any
	column?: Column
}

const ContentAd: React.FC<ContentProps> = ({ data = {}, column, ...props }) => {
	return (
		<TrackingProvider>
			<ContentPlug
				{...props}
				title={data.title}
				url={data.url}
				baseImageUrl={data.cleanImage}
				logoURL={data.logoURL}
				kicker="ANNONSØRINNHOLD"
				commercialPartner={data.commercialPartner}
				ratio={0.5625}
				column={column}
			/>
		</TrackingProvider>
	)
}

interface Props {
	pos: number
	switchWith?: string
	column?: Column
}

const XavierContentAd: React.FC<Props> = ({ pos, column, switchWith, ...props }) => {
	const ad = useContentAd(pos - 1)
	const isMobile = useIsMobile()

	if (!ad || (ad && ad.length < 1) || (ad && ad.serveAd)) {
		return <DisplayAd switchWith={switchWith} pos={pos} />
	}
	return isMobile ? <GridRow><ContentAd {...props} column={column} data={ad} /></GridRow> : <ContentAd {...props} column={column} data={ad} />
}

export default XavierContentAd
