import React, { memo, useMemo, useEffect, useState } from 'react'
import PropTypes from 'prop-types'
import { StickyAd } from '@aller/shiny/src/molecules/StickyAd'
import styled from 'styled-components'

import { useIsMetarefresh } from '../../hooks/useIsMetarefresh'
import { getPrebidConfigForSlot, getSlotNameForPath, getSite, getPath } from './config'
import AdSlot from './AdSlot'
import { useAdsStore } from './Provider'

const site = getSite()
const path = getPath()

const StyledStickyAd = styled(StickyAd)`
	padding-bottom: ${props => props.theme.variables.verticalBase};
`
const StickyRight = ({ pos, isSkyscraper = false }) => {
	let slot = 'ad-sticky-right'
	const { showSkyscraper } = useAdsStore()

	if (isSkyscraper) {
		slot = 'ad-sticky-right-top'
	}

	const [shouldShow, setShouldShow] = useState(true)

	const isMetaRefresh = useIsMetarefresh()
	const slotName = getSlotNameForPath(site, path, isMetaRefresh)
	const adOptions = useMemo(
		() => ({
			slotName,
			dimensions: [
				[[300, 600], [180, 500], [180, 700], [160, 600], 'fluid'],
				[[180, 500], [180, 700], [160, 600], 'fluid'],
				[[160, 600]],
			],
			sizemap: {
				breakpoints: [[1625, 600], [1385, 600], [1345, 600]],
				refresh: true,
			},
			display: 'desktop',
			targeting: {
				platform: 'wolverine-logan',
				pos: isSkyscraper ? `sticky-right-top${pos}` : `sticky-right${pos}`,
			},
			bidding: {
				prebid: getPrebidConfigForSlot(site, slot),
			},
		}),
		[slotName, isSkyscraper, pos, slot],
	)

	useEffect(() => {
		if (window.innerWidth <= 1345) {
			setShouldShow(false)
		}
	}, [])

	if (!shouldShow) return null
	if (isSkyscraper && !showSkyscraper) return null
	return (
		<StyledStickyAd
			height="600px"
			width="300px"
			sticky="right"
			shouldHideAttribution={false}
			topOffset="6rem"
		>
			<AdSlot id={`${slot}${pos}`} rootMargin="400px" {...adOptions} />
		</StyledStickyAd>
	)
}

StickyRight.propTypes = {
	pos: PropTypes.number,
	isSkyscraper: PropTypes.bool,
}

StickyRight.defaultProps = {
	pos: 1,
	isSkyscraper: false,
}
StickyRight.whyDidYouRender = true

export default memo(StickyRight)
