import React from 'react'
import PropTypes from 'prop-types'
import { AdWrapper } from '@aller/shiny/src/atoms/AdWrapper'

import { useIsMetarefresh } from '../../hooks/useIsMetarefresh'
import { getPrebidConfigForSlot, getSlotNameForPath, getSite, getPath } from './config'
import AdSlot from './AdSlot'

const site = getSite()
const path = getPath()

const SmartBanner = ({ pos, slot }) => {
	const isMetaRefresh = useIsMetarefresh()
	const slotName = getSlotNameForPath(site, path, isMetaRefresh)
	const prebid = getPrebidConfigForSlot(site, slot)

	const adOptions = {
		slotName,
		dimensions: [[980, 300], [980, 600], 'fluid'],
		display: 'all',
		targeting: {
			platform: 'wolverine-logan',
			pos: `${slot.slice(3)}${pos}`,
		},
		bidding: {
			prebid,
		},
	}

	return (
		<AdWrapper height="300px" width="980px">
			<AdSlot id={`${slot}${pos}`} rootMargin="400px" {...adOptions} />
		</AdWrapper>
	)
}

SmartBanner.propTypes = {
	pos: PropTypes.number,
	slot: PropTypes.oneOf(['ad-smartbanner', 'ad-smartbanner-perz']),
}

SmartBanner.defaultProps = {
	pos: 1,
	slot: 'ad-smartbanner',
}

SmartBanner.whyDidYouRender = true

export default SmartBanner
