import React from 'react'
import PropTypes from 'prop-types'
import { AdWrapper } from '@aller/shiny/src/atoms/AdWrapper'

import { useIsMetarefresh } from '../../hooks/useIsMetarefresh'
import { getPrebidConfigForSlot, getSlotNameForPath, getSite, getPath } from './config'
import AdSlot from './AdSlot'

const slot = 'ad-netboard'
const site = getSite()
const path = getPath()
const prebid = getPrebidConfigForSlot(site, slot)

const Netboard = ({ pos }) => {
	const isMetaRefresh = useIsMetarefresh()
	const slotName = getSlotNameForPath(site, path, isMetaRefresh)
	const adOptions = {
		slotName,
		dimensions: [[580, 500], [580, 400], 'fluid'],
		display: 'all',
		targeting: {
			platform: 'wolverine-logan',
			pos: `netboard${pos}`,
		},
		bidding: {
			prebid,
		},
	}

	return (
		<AdWrapper height="400px" width="580px">
			<AdSlot id={`${slot}${pos}`} rootMargin="400px" {...adOptions} />
		</AdWrapper>
	)
}

Netboard.propTypes = {
	pos: PropTypes.number,
}

Netboard.defaultProps = {
	pos: 1,
}

Netboard.whyDidYouRender = true
Netboard.slot = slot

export default Netboard
