import React from 'react'
import PropTypes from 'prop-types'

import DesktopBanner from './DesktopBanner'
import Netboard from './Netboard'
import Fullscreen from './Fullscreen'

const config = {
	interval: 3,
	// override keys are actualy row numbers, not ad count
	overrides: {
		0: DesktopBanner, // default
		3: Netboard,
		6: Fullscreen,
	},
}

const renderAd = (index, counters, child) => {
	const Ad = config.overrides[index] || config.overrides[0]
	const count = (counters[Ad.slot] || 0) + 1
	counters[Ad.slot] = count

	return (
		<>
			{child}
			<Ad pos={count} />
		</>
	)
}

const Intercalator = ({ children }) => {
	const counters = {}

	return (
		<>
			{React.Children.map(children, (child, i) => {
				const index = i + 1
				if (index % config.interval === 0) {
					return renderAd(index, counters, child)
				}
				return <>{child}</>
			})}
		</>
	)
}
Intercalator.propTypes = {
	children: PropTypes.node,
}
Intercalator.defaultProps = {
	children: null,
}

Intercalator.whyDidYouRender = true

export default Intercalator
