import React from 'react'
import PropTypes from 'prop-types'
import { AdWrapper } from '@aller/shiny/src/atoms/AdWrapper'
import { useIsMetarefresh } from '../../hooks/useIsMetarefresh'
import { getPrebidConfigForSlot, getSlotNameForPath, getSite, getPath } from './config'

import AdSlot from './AdSlot'
import GridRow from '../GridRow'

const slot = 'ad-desktopbanner'
const site = getSite()
const path = getPath()
const prebid = getPrebidConfigForSlot(site, slot)

const DesktopBanner = ({ pos }) => {
	const isMetaRefresh = useIsMetarefresh()
	const slotName = getSlotNameForPath(site, path, isMetaRefresh)
	const adOptions = {
		slotName,
		dimensions: [[980, 300], [970, 250]],
		display: 'all',
		targeting: {
			platform: 'wolverine-logan',
			pos: `desktopbanner${pos}`,
		},
		bidding: {
			prebid,
		},
	}

	return (
		<GridRow>
			<AdWrapper height="300px" width="980px">
				<AdSlot id={`${slot}${pos}`} rootMargin="400px" {...adOptions} />
			</AdWrapper>
		</GridRow>
	)
}

DesktopBanner.propTypes = {
	pos: PropTypes.number,
}

DesktopBanner.defaultProps = {
	pos: 1,
}

DesktopBanner.whyDidYouRender = true
DesktopBanner.slot = slot

export default DesktopBanner
