import React from 'react'
import { Col } from '@aller/shiny/src/atoms/Col'

import { useIsMobile } from '@aller/shared/hooks/useIsMobile'

import LoganPlug from '../LoganPlug'
import GridRow from '../GridRow'

import Banner from './Banner'
import MediumRectangle from './MediumRectangle'
import SmartBanner from './SmartBanner'

import { Column } from '../FlexCol/types'

interface Props {
	url: string
	cleanImage: string
	title: string
	preset: string
	serveAd: boolean
	commercialPartner: string
	pos: number
	column?: Column
	ratio?: number
	desktopAd?: 'medium-rectangle' | 'smartbanner'
	withRow?: boolean
}

const ContentSwitch: React.FC<Props> = ({
	serveAd,
	pos,
	cleanImage,
	preset,
	title,
	url,
	commercialPartner,
	column = { xs: 12 },
	ratio = 0.75,
	desktopAd = 'medium-rectangle',
	withRow = false,
}: Props) => {
	const mobile = useIsMobile()

	if (serveAd || !url) {
		if (mobile) {
			return <Banner pos={pos} slot="ad-banner-perz" />
		}

		switch (desktopAd) {
			case 'smartbanner':
				return <SmartBanner pos={pos} slot="ad-smartbanner-perz" />
			default:
				return (
					<Col {...column}>
						<MediumRectangle pos={pos} slot="ad-medium-rectangle-perz" />
					</Col>
				)
		}
	}

	const plug = (
		<LoganPlug
			isContentMarketing
			baseImageUrl={cleanImage}
			column={column}
			commercialPartner={commercialPartner}
			preset={preset}
			url={url}
			title={title}
			ratio={ratio}
		/>
	)

	if (withRow) {
		return <GridRow>{plug}</GridRow>
	}

	return <>{plug}</>
}

export default ContentSwitch
