import React, { useEffect, useCallback, memo } from 'react'
import PropTypes from 'prop-types'
import ulog from 'ulog'
import { useInView } from 'react-intersection-observer'
import { AdSettingsCog } from './AdSettingsCog'

import { useSlotsStore, useAdsDispatch, useAdsStore, gptSlots } from './Provider'

const log = ulog('ads')

const AdSlot = ({ id, rootMargin, ...adOptions }) => {
	const slots = useSlotsStore()
	const dispatch = useAdsDispatch()
	const { arcAds } = useAdsStore()

	const [ref, inView] = useInView({
		threshold: 0,
		triggerOnce: true,
		rootMargin,
	})

	const handleClick = useCallback(() => dispatch({ type: 'SHOW_MODAL' }), [dispatch])

	useEffect(() => {
		if (inView && arcAds) {
			dispatch({
				type: 'REGISTER_AD',
				options: {
					id,
					...adOptions,
				},
			})
		}

		return function cleanup() {
			if (gptSlots && gptSlots[id]) {
				log.info(`Cleaning up ad ${id}`)
				window.googletag.destroySlots([gptSlots[id]])
			}
		}
	}, [inView, arcAds]) // eslint-disable-line

	return (
		<>
			{slots && slots[id] && slots[id].showCog && <AdSettingsCog onClick={handleClick} />}
			<div ref={ref} id={id} className="adunit wolverine-ads" key={`adslot-${id}`} />
		</>
	)
}
AdSlot.propTypes = {
	id: PropTypes.string.isRequired,
	rootMargin: PropTypes.string.isRequired,
}

AdSlot.whyDidYouRender = true

export default memo(AdSlot)
