import styled from 'styled-components'
import { getColor, getVariable } from '@aller/shiny/src/utils'

export const StyledWeatherContainer = styled.div`
	border: 0.1rem solid ${getColor('grayTint')};
	margin-right: calc(${getVariable('horizontalBase')} / 3);
	margin-bottom: calc(${getVariable('verticalBase')} / 1.75);
	padding: calc(${getVariable('horizontalBase')} * 2);

	h4,
	a {
		display: inline;
	}

	.settings {
		float: right;
		font-size: ${getVariable('uiSmallSize')};
		border-bottom: none;
	}
`

export const StyledWeatherData = styled.div`
	display: flex;
	flex-direction: column;
	width: 100%;
	margin-bottom: ${getVariable('verticalBase')};
`

export const StyledWeatherUpcoming = styled.div`
	display: flex;
	align-items: center;
	justify-content: space-between;
	border-bottom: 0.1rem solid ${getColor('grayTintLight')};
	padding: 0.5rem 0;

	.location,
	.day {
		flex: 1 0 50%;
	}

	.symbol {
		flex: 1 0 25%;
	}
`

export const StyledWeatherToday = styled(StyledWeatherUpcoming)`
	.place {
		font-weight: 600;
	}

	.place,
	.municipality {
		display: block;
	}

	.municipality {
		font-size: ${getVariable('uiTinySize')};
		line-height: ${getVariable('uiTinyLineHeight')};
	}

	.temperature {
		font-size: 2.4rem;
		text-align: right;
	}
`

export const StyledAboveZero = styled.span`
	flex: 1 0 25%;
	color: ${getColor('solRed')};
	text-align: right;
`

export const StyledBelowZero = styled.span`
	flex: 1 0 25%;
	color: ${getColor('blueDark')};
	text-align: right;
`
