import styled from 'styled-components'
import { getColor, getVariable } from '@aller/shiny/src/utils'

export const StyledNewspapers = styled.div`
	margin-right: calc(${getVariable('horizontalBase')});
	margin-bottom: calc(${getVariable('verticalBase')} / 1.75);
	padding: ${getVariable('horizontalBase')} ${getVariable('horizontalBase')};
`

export const StyledCustomSources = styled.div`
	text-align: center;
	margin-top: calc(${getVariable('verticalBase')} / 4);
	a {
		margin-left: ${getVariable('horizontalBase')};
		margin-top: ${getVariable('horizontalBase')};
	}
`

export const StyledNewspapersList = styled.div`
	display: flex;
	justify-content: center;
	flex-wrap: wrap;
	flex: 0 0 20%;

	a {
		flex: 0 0 25%;
		border-bottom: none;
		margin-bottom: 0.2rem;
		text-align: center;
		padding-top: calc(${getVariable('verticalBase')} / 4);
		transition: all 0.2s ease-in-out;
		&:hover {
			transform: scale(1.1);
			text-decoration: none;
		}
	}

	.logo {
		border-radius: 1rem;
		height: 4rem;
		width: 4rem;
		box-shadow: 0 0.2rem 3rem 0.1rem rgba(0, 0, 0, 0.1);
	}

	.source {
		display: block;
		font-size: 1.2rem;
		padding-top: 0.5rem;
		line-height: ${getVariable('uiTinyLineHeight')};
		color: ${getColor('type')};
		margin-bottom: calc(${getVariable('verticalBase')} / 2);
	}
`
