import PropTypes from 'prop-types'
import React from 'react'

import { SmallRoundedButton } from '@aller/shiny/src/atoms/RoundedButtons'
import NewspapersList from './NewspapersList'
import sources from './sources'
import { StyledNewspapers, StyledCustomSources } from '../styles/NewspapersStyles'

import Dropdown from './Dropdown'

class Newspapers extends React.Component {
	constructor() {
		super()

		this.state = {
			customSources: {}
		}
	}

	componentDidMount() {
		this.fetchSources()
	}

	fetchSources() {
		//		if (this.props.canStore) {
		const customSources = localStorage.getItem('MyLinksOnSOL')
		const parsedSources = customSources ? JSON.parse(customSources) : {}

		this.setState({ customSources: parsedSources })
		//	}
	}

	addSource(ev) {
		if (ev.target.value === 'default') {
			return
		}
		const { customSources } = this.state

		const source = JSON.parse(ev.target.value)
		const key = source.domain

		customSources[key] = source
		localStorage.setItem('MyLinksOnSOL', JSON.stringify(customSources))
		this.setState({ customSources })
	}

	resetSources() {
		localStorage.setItem('MyLinksOnSOL', '')
		this.setState({ customSources: {} })
	}

	renderAvailableSources() {
		const sourceOptions = sources.map((item, i) => {
			const localNewspaper = JSON.stringify({ name: `${item.name}`, domain: `${item.domain}` })
			return <option key={i} value={localNewspaper}>{`${item.name}`}</option>
		})

		const { customSources } = this.state

		const removeButton =
			Object.keys(customSources).length > 0 ? (
				<SmallRoundedButton onClick={() => this.resetSources()}>
					Fjern mine lokalaviser
				</SmallRoundedButton>
			) : null

		return (
			<StyledCustomSources>
				<Dropdown defaultValue="default" onChange={e => this.addSource(e)}>
					<option value="default">Legg til flere aviser</option>
					{sourceOptions}
				</Dropdown>
				{removeButton}
			</StyledCustomSources>
		)
	}

	render() {
		const { customSources } = this.state
		const { canStore } = this.props
		return (
			<StyledNewspapers className="newspapers lp_fp_avisknapper">
				<NewspapersList customSources={customSources} />
				{canStore ? this.renderAvailableSources() : null}
			</StyledNewspapers>
		)
	}
}

Newspapers.defaultProps = {
	canStore: false
}

Newspapers.propTypes = {
	canStore: PropTypes.bool
}

export default Newspapers
