// Base dropdown
import styled from 'styled-components'

import { getColor, getVariable } from '@aller/shiny/src/utils'

const Dropdown = styled.select`
	appearance: none;
	border: 0;
	background-image: url('https://cdn1.iconfinder.com/data/icons/cc_mono_icon_set/blacks/16x16/br_down.png');
	background-color: #f3f3f3;
	background-repeat: no-repeat;
	background-position: right 1.5rem center;
	border-radius: 6rem;
	color: #222;
	font-size: 1.4rem;
	margin: 0;
	padding: 1rem 1.5rem;
	transition: 0.2s all;
	font-weight: 700;
	text-align: center;
	&:hover {
		background-color: #dedede;
		cursor: pointer;
	}
	width: 70%;
	@media only screen and (max-width: 600px) {
		width: 100%;
	}
`

export default Dropdown
