import React from 'react'
import propTypes from 'prop-types'

// The Link tag should go in the HTML head section
const Link = ({ rel, type, href, sizes, crossOrigin }) => (
	<link
		{...{
			rel,
			type,
			href,
			sizes,
			crossOrigin,
		}}
	/>
)
Link.propTypes = {
	rel: propTypes.string,
	type: propTypes.string,
	href: propTypes.string,
	sizes: propTypes.string,
	crossOrigin: propTypes.string,
}
Link.defaultProps = {
	rel: null,
	type: null,
	href: null,
	sizes: null,
	crossOrigin: null,
}

export default Link
