import React from 'react'
import { useInView } from 'react-intersection-observer'
import GridSection, { Props } from '../GridSection'

const StyledAside = GridSection.withComponent('aside')
const LazyAside: React.FC<Props> = ({ children, ...rest }) => {
	const [ref, inView] = useInView({
		triggerOnce: true
	})
	return (
		<StyledAside {...rest} ref={ref}>
			{inView && children}
		</StyledAside>
	)
}
;(LazyAside as any).whyDidYouRender = true
export default LazyAside
