import styled from 'styled-components'
import { css } from 'styled-components'
import { Grid } from '@aller/shiny/src/atoms/Grid'
import { getColor } from '@aller/shiny/src/utils/get-color'
import { getVariable } from '@aller/shiny/src/utils/get-variable'

export interface Props {
	type?: 'advertisement'
	fluid?: boolean
}

const GridSectionComponent = Grid.withComponent('section')
const GridSection = styled(GridSectionComponent)<Props>`
	position: relative;
	padding-bottom: ${getVariable('verticalBase')};
	padding-top: ${getVariable('verticalBase')};
	background-color: ${getColor('background')};

	@media screen and (max-width: ${props => (props.theme as any).flexboxgrid.breakpoints.sm}rem) {
		margin-bottom: ${getVariable('verticalBase')};
	}

	${(props: Props) => {
		if (props.type === 'advertisement') {
			return css`
				height: auto;
				background-color: transparent;
				padding: 0;
				width: 100%;
				z-index: 0;
			`
		}

		return css``
	}}
`

export default GridSection
