import styled from 'styled-components'
import { css } from 'styled-components'

import config, { DIMENSION_NAMES } from '../../utils/flex-grid-config'

interface Props {
	fluid?: boolean
}

const Grid = styled.div<Props>`
	margin-right: auto;
	margin-left: auto;
	padding-right: ${p => `${config(p).outerMargin}rem`};
	padding-left: ${p => `${config(p).outerMargin}rem`};
	${p =>
		!p.fluid &&
		css`
			${DIMENSION_NAMES.map(t => {
				return (
					config(p).container[t] &&
					config(p).media[t]`
       width: ${config(p).container[t]}rem;
    `
				)
			})}
		`}
`

Grid.displayName = 'Grid'

export default Grid
