import React from 'react'
import propTypes from 'prop-types'

class EsiInclude extends React.Component {
	shouldComponentUpdate() {
		return false
	}

	render() {
		const { src } = this.props

		return (
			<div
				suppressHydrationWarning
				className="esi-include containMe"
				dangerouslySetInnerHTML={{ __html: `<esi:include src="${src}" />` }} // eslint-disable-line react/no-danger
			/>
		)
	}
}
EsiInclude.propTypes = {
	src: propTypes.string.isRequired,
}

export default EsiInclude
