/* eslint-disable import/prefer-default-export */
import React from 'react'
import propTypes from 'prop-types'

export class ErrorBoundary extends React.Component {
	constructor(props) {
		super(props)
		this.state = { hasError: false }
	}

	componentDidCatch(error, info) {
		// Display fallback UI
		this.setState({ hasError: true })
		// You can also log the error to an error reporting service
		// logErrorToMyService(error, info);
	}

	render() {
		const { children } = this.props
		const { hasError } = this.state

		if (hasError) {
			// You can render any custom fallback UI
			return <h1>Something went wrong.</h1>
		}
		return children
	}
}
ErrorBoundary.propTypes = {
	children: propTypes.node,
}
ErrorBoundary.defaultProps = {
	children: null,
}
