import styled from 'styled-components'
import { getColor } from '@aller/shiny/src/utils/get-color'
import { getVariable } from '@aller/shiny/src/utils/get-variable'

export const ResultPagination = styled.div`
	padding: 6rem 0 4rem 0;
	text-align: center;
	margin: 0 auto;
`
export const Pagination = styled.ul`
	list-style-position: outside;
	font-family: inherit;
	display: flex;
	align-items: center;

	li {
		color: silver;
		font-size: ${getVariable('uiRegularSize')};
		height: 3rem;
		width: 3.8rem;
		display: flex;
		align-items: center;
		justify-content: center;

		a {
			cursor: pointer;
			text-decoration: none;
			display: block;
			padding: 0.0625rem 0.625rem 0.0625rem;
			color: ${getColor('link')};
			background: none;
			border-radius: 0.3rem;
			font-weight: ${getVariable('uiWeight')};
			transition: background-color 300ms ease-out;

			&:hover {
				text-decoration: underline;
			}
		}
	}

	.unavailable {
		text-decoration: none;
		cursor: default;
		color: silver;
	}

	.current {
		background: ${getColor('link')};
		color: ${getColor('white')};
		font-weight: ${getVariable('uiWeightSemiBold')};
		cursor: default;
		border-radius: 0.4rem;

		a {
			background: ${getColor('link')};
			color: ${getColor('white')};
			font-weight: ${getVariable('uiWeightSemiBold')};
			cursor: default;
			text-decoration: none;

			&:hover {
				text-decoration: none;
			}
		}
	}

	.arrow {
		font-size: ${getVariable('uiSmallSize')};
		font-family: 'Helveticons';

		.icon-left-double-arrow {
			&:before {
				content: '\\e73a';
			}
		}
		.icon-arrow-alt-left {
			&:before {
				content: '\\e87F';
			}
		}
		.icon-arrow-alt-right {
			&:before {
				content: '\\e880';
			}
		}
		.icon-right-double-arrow {
			&:before {
				content: '\\e714';
			}
		}
		@media screen and (max-width: ${props => props.theme.flexboxgrid.breakpoints.md}em) {
			display: none;
		}
	}
`
