import styled from 'styled-components'
import { LargeHeading, HugeHeading, MediumHeading } from '@aller/shiny/src/atoms/Heading'
import { Row } from '@aller/shiny/src/atoms/Row'
import { Grid } from '@aller/shiny/src/atoms/Grid'
import { getColor } from '@aller/shiny/src/utils/get-color'
import { getVariable } from '@aller/shiny/src/utils/get-variable'

export const EavisSearchTopWrapper = styled.div`
	background-image: url('https://media.dbstatic.no/eavis/sok/archive-cover.png');
	width: 100%;
	min-height: 20rem;
	background-position: top center;
	background-size: cover;
	padding-top: 7rem;
	padding-bottom: 7rem;
`
export const EavisSearchHeading = styled(HugeHeading)`
	text-align: center;
	color: ${getColor('white')};
	font-weight: ${getVariable('uiWeight')};
	font-family: ${getVariable('mainFont')};
	margin: 0 auto 7rem;
	@media screen and (max-width: ${props => props.theme.flexboxgrid.breakpoints.md}em) {
		font-size: 3.4rem;
	}
`

export const EavisSearchForm = styled.form`
	display: flex;
	@media screen and (max-width: ${props => props.theme.flexboxgrid.breakpoints.md}em) {
		flex-wrap: wrap;
	}
`
export const SearchToggle = styled.div`
	margin: auto auto 2rem auto;
	> span {
		color: ${getColor('white')};
		margin-right: 1rem;
	}
`
export const SearchSlider = styled.div`
	min-height: 5rem;
	overflow: hidden;
	width: 100%;
`
export const SliderCellContainer = styled.div`
	display: flex;
	width: 200%;
	position: relative;
	margin: 0;
	left: 0;
	transition: all 0.5s ease-in-out;
	&.velgAvis {
		left: -100%;
	}
`
export const SliderFormCell = styled.div`
	flex: 0 0 50%;
`
export const EavisSearchNaviButton = styled.button`
	display: inline-block;
	color: ${getColor('white')};
	font-size: ${getVariable('uiSmallSize')};
	padding: 0.3rem 1.6rem;
	line-height: ${getVariable('uiLargeLineHeight')};
	font-weight: ${getVariable('uiWeightBold')};
	font-family: inherit;
	cursor: pointer;
	background: transparent;
	border: 0.1rem solid ${getColor('white')};
	margin-left: 1rem;
	letter-spacing: 0.1rem;
	&:focus {
		outline: none;
	}
	&.active {
		background: ${getColor('white')};
		color: ${getColor('link')};
	}
`
export const SearchInputContainer = styled.div`
	label {
		line-height: ${getVariable('uiLargeLineHeight')};
		color: ${getColor('white')};
	}
	input {
		width: 100%;
		height: 4rem;
		padding: 0.6rem;
		font-family: inherit;
		font-size: ${getVariable('uiRegularSize')};
	}
	select {
		width: 100%;
		height: 4rem;
		padding: 0.8rem;
		font-family: inherit;
		font-size: ${getVariable('uiRegularSize')};
		-webkit-appearance: none;
		background-size: 1rem;
		background-position: right 0.5rem center;
		background-repeat: no-repeat;
		background-color: ${getColor('white')};
		background-size: 1.8rem;
		background-image: url("data:image/svg+xml;utf8,<svg x='0px' y='0px' viewBox='0 0 435 255' xmlns='http://www.w3.org/2000/svg'><polygon fill='silver' points='0,41.3 40.6,0 217.5,173.1 394.4,0 435,41.3 217.5,255'/></svg>");
		&:hover {
			background-image: none;
		}
	}
	&.textInput {
		flex: auto;
		@media screen and (max-width: ${props => props.theme.flexboxgrid.breakpoints.md}em) {
			flex: 0 0 100%;
			margin-bottom: 4rem;
		}
	}
	&.dateInput {
		flex: 2;
		@media screen and (max-width: ${props => props.theme.flexboxgrid.breakpoints.md}em) {
			flex: 0 0 50%;
			&:nth-of-type(2) {
				padding-right: 0.5rem;
			}
			&:nth-of-type(3) {
				padding-left: 0.5rem;
			}
		}
	}
	&.selectInput {
		flex: 2;
		@media screen and (max-width: ${props => props.theme.flexboxgrid.breakpoints.md}em) {
			flex: 0 0 100%;
			margin-left: 0;
			margin-top: 1rem;
			&:nth-of-type(1) {
				margin-top: 0;
			}
		}
	}
	&:not(:nth-of-type(1)) {
		margin-left: 1rem;
		@media screen and (max-width: ${props => props.theme.flexboxgrid.breakpoints.md}em) {
			margin-left: 0;
		}
	}
`
export const EavisSearchButton = styled.button`
	flex: 0.6;
	color: ${getColor('white')};
	font-size: ${getVariable('uiRegularSize')};
	font-weight: ${getVariable('uiWeightBold')};
	font-family: inherit;
	cursor: pointer;
	background: ${getColor('link')};
	border: 0.1rem solid #2c53a1;
	margin-left: 1rem;
	height: 4rem;
	align-self: flex-end;
	&:hover {
		background: #2c53a1;
	}
	&:focus {
		outline: none;
	}
	@media screen and (max-width: ${props => props.theme.flexboxgrid.breakpoints.md}em) {
		flex: 0 0 100%;
		margin-left: 0;
		margin-top: 3rem;
	}
`
export const EavisSearchInformation = styled.div`
	text-align: center;
	padding: 2.5rem 0;
	box-shadow: 0 0.2rem 0.6rem rgba(0, 0, 0, 0.1);
`
export const EavisSearchInformationLink = styled.a`
	font-style: italic;
	color: ${getColor('darkness')};
	font-size: ${getVariable('uiRegularSize')};
	text-decoration: none;

	> span {
		font-weight: ${getVariable('uiWeightBold')};
	}
`
export const SearchArchiveRow = styled(Row)`
	display: flex;
	flex-wrap: wrap;
	padding-top: 11rem;
`
export const SearchArchiveItem = styled.div`
	padding: 2rem;
	flex: 3;
	text-align: center;
	> img {
		width: 10rem;
		height: 10rem;
	}
	> span {
		font-size: ${getVariable('uiRegularSize')};
		line-height: ${getVariable('headingSmallLineHeight')};
	}
`
export const EavisSearchIssueListStyled = styled.ul`
	list-style: none;
	margin-left: 0;
	display: flex;
	flex-wrap: wrap;
	flex-direction: row;
`
export const EavisSearchIssueListItemStyled = styled.li`
	padding: 1rem;
	margin: 1rem;
	display: block;
	border: 0.1rem solid ${getColor('grayTintLight')};
	flex: 0 1 auto;
	width: calc(50% - 2rem);
	@media screen and (max-width: ${props => props.theme.flexboxgrid.breakpoints.md}em) {
		flex: 1;
		flex-basis: 100%;
	}
`
export const EavisSearchIssueListItemCTATrigger = styled.a`
	text-decoration: none;
	color: ${getColor('darkness')};
	display: flex;
`
export const EavisSearchIssueListItemImageContainer = styled.div`
	display: block;
	float: none;
	flex: 0 0 15rem;
	margin-right: 1.6rem;
`
export const EavisSearchIssueListItemImage = styled.img`
	display: inline-block;
	vertical-align: middle;
`
export const EavisSearchIssueListItemTextContainer = styled.div`
	display: block;
`
export const EavisSearchIssueListItemTextSnippet = styled.div`
	font-size: ${getVariable('uiTinySize')};
	margin-bottom: 1.4rem;
	line-height: ${getVariable('uiSmallLineHeight')};
	font-family: ${getVariable('mainFont')};
`
export const EavisSearchIssueListItemTextDate = styled.div`
	text-transform: uppercase;
	font-weight: ${getVariable('uiWeightBold')};
	font-size: ${getVariable('uiTinySize')};
	margin-bottom: 1rem;
	padding-top: 0.6rem;
`
export const EavisSearchReadThisPage = styled.div`
	text-transform: uppercase;
	font-weight: ${getVariable('uiWeightBold')};
	font-size: ${getVariable('uiTinySize')};
	margin-bottom: 1rem;
	padding-top: 0.6rem;
`
export const EavisSearchReadThisPageButton = styled.a`
	padding: 0.5rem 1rem 0.5625rem;
	font-size: ${getVariable('uiSmallSize')};
	letter-spacing: 1px;
	text-transform: uppercase;
	background-color: ${getColor('grayTintLight')};
	border-color: ${getColor('grayTint')};
	border-style: solid;
	border-width: 0;
	cursor: pointer;
	font-family: ${getVariable('mainFont')};
	font-weight: ${getVariable('uiWeightBold')};
	line-height: ${getVariable('uiTinyLineHeight')};
	margin: 0 0 1.25rem;
	position: relative;
	text-decoration: none;
	text-align: center;
	-webkit-appearance: none;
	display: inline-block;
	transition: 0.3s ease-in-out;
	color: ${getColor('link')};

	&:hover {
		background-color: ${getColor('grayTint')};
		color: ${getColor('link')};
		text-decoration: none;
	}
`

export const EavisSearchInfoContainer = styled.div`
	padding: 2rem 1rem;
`

export const SearchPopularRow = styled(Row)`
	flex: 100%;
	display: flex;
	flex-wrap: wrap;
	align-items: center;
	justify-content: center;
`

export const SearchPopularLink = styled.a`
	color: ${getColor('grayTintDark')};
	border-bottom: 1px solid ${getColor('secondary')};
	padding-bottom: 0.3rem;
	margin: 1.5rem 1.5rem 0;
	text-decoration: none;
	display: inline;
`
export const SearchMHeading = styled(LargeHeading)`
	margin-left: auto;
	margin-right: auto;
	font-weight: ${getVariable('uiWeightBold')};
	@media screen and (min-width: ${props => props.theme.flexboxgrid.breakpoints.md}em) {
		margin-left: auto;
		margin-right: auto;
		font-weight: ${getVariable('uiWeightBold')};
	}
`
export const XMediumHeading = styled(MediumHeading)`
	margin-top: 0;
	font-size: 3rem;
	@media screen and (min-width: ${props => props.theme.flexboxgrid.breakpoints.md}em) {
		margin-top: 0;
		font-size: 3rem;
	}
`
export const SearchDescritpion = styled.div`
	margin-top: 11rem;
	padding: 2rem 0;
	display: flex;
	flex-wrap: wrap;
	background: ${getColor('darkness')};
	color: ${getColor('white')};
	align-items: center;
	justify-content: center;
	> div {
		display: flex;
		flex-wrap: wrap;
	}
`

export const SearchDescritpionCol = styled.div`
	flex: 0 0 50%;
	padding: 0 1rem;
	@media screen and (max-width: ${props => props.theme.flexboxgrid.breakpoints.md}em) {
		flex: 0 0 100%;
	}
	> p {
		line-height: ${getVariable('headingSmallLineHeight')};
		font-family: inherit;
		&.italic {
			font-style: italic;
		}
	}
`
export const SearchButAbonnementLink = styled.a`
	color: ${getColor('darkness')};
	display: inline-block;
	text-decoration: none;
	padding: 1rem 3rem;
	background: ${getColor('grayTintLight')};
	border: 1px solid ${getColor('grayTint')};
	font-weight: ${getVariable('uiWeightBold')};
	text-transform: uppercase;
	font-size: ${getVariable('uiRegularSize')};
	&:hover {
		background: ${getColor('grayTint')};
	}
`

export const PopularSearch = styled(Grid)`
	padding-top: 11rem;
	display: flex;
	flex-wrap: wrap;
`
export const CarouselContainer = styled(Grid)`
	padding: 12rem 0 0;
	.carousel-slider {
		.control-arrow {
			margin-top: 5rem;
			margin-bottom: 5rem;
			&:hover {
				background: rgba(0, 0, 0, 0.4);
			}
		}
	}
	.control-dots {
		.dot {
			background: ${getColor('darknessLight')};
			&:focus {
				outline: none;
			}
		}
	}
	.slider-wrapper {
		padding-bottom: 5rem;
		padding-top: 5rem;
		.slider {
			.slide {
				padding: 0 0.5rem;
				background: none;
				.legend {
					top: -5.5rem;
					bottom: auto;
					background: none;
					color: ${getColor('darkness')};
					opacity: 1;
					font-size: ${getVariable('uiLargeSize')};
					font-family: ${getVariable('mainFont')};
				}
			}
		}
	}
`

export const HistorikLink = styled.a`
	display: block;
`
