import styled from 'styled-components'
import { getVariable } from '@aller/shiny/src/utils/get-variable'
import { getColor } from '@aller/shiny/src/utils/get-color'

export const PlussBarContainer = styled.div`
	top: -1px;
	padding: 5rem 0 0;
	position: relative;
	display: flex;
	flex-wrap: wrap;
	border-bottom: 1px solid ${getColor('grayTintLight')};
	font-family: ${getVariable('mainFont')};
	a {
		text-decoration: none;
	}
	@media screen and (max-width: ${props => props.theme.flexboxgrid.breakpoints.md}em) {
		font-family: ${getVariable('mainFont')};
	}
`
export const PlussBarLogo = styled.div`
	width: 12rem;
	border-right: 1px solid ${getColor('grayTintLight')};
	padding: 0.5rem;

	a {
		display: flex;
		align-items: center;
		justify-content: center;
		.pLogo {
			background: ${getColor('darkness')};
			padding: 0.5rem;
			width: 3rem;
			height: 3rem;
			display: inline-block;
			margin-right: 0.6rem;
		}
		.pTitle {
			text-transform: uppercase;
			letter-spacing: 0.1rem;
		}
	}
`
export const PlussBarNav = styled.div`
	flex: 1;
	overflow-x: auto;
	overflow-y: hidden;
	white-space: nowrap;
	position: relative;
	padding: 0.5rem;
	display: flex;
	align-items: center;
	ul {
		li {
			display: inline;
			a {
				padding: 0 0.5rem;
			}
		}
	}
`
