import React from 'react'
import propTypes from 'prop-types'
import {
	EavisTopIssueLogin,
	LoginButton,
	GetSubscriptionButton,
	GetSubscriptionButtonContainer,
} from './index'

import { GetPaywallURL } from './functions'

// @todo add some type of different domain support
const LogInOut = ({ loggedIn }) => {
	const logInOutHandler = () => {
		const redir = loggedIn
			? 'https://www.dagbladet.no/app/dug/v1/client/logout'
			: 'https://www.dagbladet.no/app/dug/v1/client/login'

		window.location.href = redir
	}
	const logInOutText = loggedIn ? 'Logg ut' : 'Logg inn'
	return (
		<>
			<EavisTopIssueLogin>
				<LoginButton onClick={logInOutHandler}>{logInOutText}</LoginButton>
			</EavisTopIssueLogin>
			{!loggedIn && (
				<GetSubscriptionButtonContainer>
					<GetSubscriptionButton
						onClick={() => {
							// send to paywall
							window.location.href = GetPaywallURL()
						}}
					>
						Kjøp dagbladet pluss og få tilgang til eavis og arkivet!
					</GetSubscriptionButton>
				</GetSubscriptionButtonContainer>
			)}
		</>
	)
}

LogInOut.propTypes = {
	loggedIn: propTypes.bool.isRequired,
}

export default LogInOut
