import React, { useState } from 'react'
import propTypes from 'prop-types'
import { format } from 'date-fns'
import { nb } from 'date-fns/locale'
import {
	EavisTopIssueContainer,
	EavisTopIssueCurrentIssue,
	EavisCurrentIssueImage,
	EavisTopIssueSubscriptionInfo,
	EavisIssueImage,
	EavisIssueControls,
	EavisIssueImageShowPreview,
	EavisIssueShowDetails,
	EavisIssueDate,
	EavisXLargeHead,
	EavisLargeHeading,
	EavisSmallHead,
	EavisTopIssueDescription,
	EavisBoldText,
} from './index'
import LogInOut from './LogInOutBlock'
import EavisImagePreview from './EavisImagePreview'
import { GetIssueLink } from './functions'

const EavisTopIssue = ({ issue, loggedIn }) => {
	const date = new Date(issue.date)
	const issueDate = format(date, 'EEEE d. MMMM', { locale: nb })
	const issueLink = GetIssueLink(date)

	const [isOpen, setOpened] = useState(false)
	const showImgPreview = () => {
		setOpened(true)
	}
	const hideImgPreview = () => {
		setOpened(false)
	}

	return (
		<EavisTopIssueContainer>
			<EavisTopIssueCurrentIssue>
				<EavisCurrentIssueImage>
					<EavisIssueImage src={`https://${issue.thumb_medium}`} />
					<EavisIssueControls className="eavis-controls">
						<EavisIssueImageShowPreview onClick={showImgPreview}>
							Se stort bilde
						</EavisIssueImageShowPreview>
						<EavisIssueShowDetails href={issueLink}>Vis utgaven</EavisIssueShowDetails>
					</EavisIssueControls>
				</EavisCurrentIssueImage>
				<EavisIssueDate>
					<EavisSmallHead>Siste utgave</EavisSmallHead>
					<EavisLargeHeading>{issueDate}</EavisLargeHeading>
				</EavisIssueDate>
			</EavisTopIssueCurrentIssue>
			<EavisTopIssueSubscriptionInfo>
				<EavisXLargeHead>
					Alt fra papiravisen og
					<br />
					Dagbladet Pluss
				</EavisXLargeHead>
				<br />
				<EavisLargeHeading>- nå i samme abonnement!</EavisLargeHeading>
				<LogInOut loggedIn={loggedIn} />

				<EavisTopIssueDescription>
					<EavisBoldText>
						Dagbladet som eAvis og Dagbladet Pluss i ett og samme abonnement.
					</EavisBoldText>
					<p>
						Les alt på PC, nettbrett eller mobil. På mobil eller nettbrett må man laste ned
						Dagbladet eAvis-app.
					</p>
					<p>
						Ønsker du å kjøpe enkeltutgaver av eAvisa kan dette kun gjøres i eAvis-appen. <br />
						Har du spørsmål vedrørende abonnementet, ta kontakt med vår kundeservice på epost:
						dbid@dagbladet.no.
					</p>
				</EavisTopIssueDescription>
			</EavisTopIssueSubscriptionInfo>
			<EavisImagePreview
				imgSrc={`https://${issue.thumb_medium}`}
				isOpen={isOpen}
				closePreview={hideImgPreview}
			/>
		</EavisTopIssueContainer>
	)
}

EavisTopIssue.propTypes = {
	issue: propTypes.shape({
		date: propTypes.string.isRequired,
		thumb: propTypes.string.isRequired,
		thumb_medium: propTypes.string.isRequired,
		catalog: propTypes.number.isRequired,
	}).isRequired,
	loggedIn: propTypes.bool.isRequired,
}

export default EavisTopIssue
