import React from 'react'
import propTypes from 'prop-types'
import format from 'date-fns/format'
import nb from 'date-fns/locale/nb'
import {
	EavisSearchIssueListItemStyled,
	EavisSearchIssueListItemCTATrigger,
	EavisSearchIssueListItemImageContainer,
	EavisSearchIssueListItemImage,
	EavisSearchIssueListItemTextContainer,
	EavisSearchIssueListItemTextDate,
	EavisSearchIssueListItemTextSnippet,
	EavisSearchReadThisPage,
	EavisSearchReadThisPageButton,
} from './search'
import { GetIssuePageLink } from './functions'

const EavisSearchIssueListItem = ({ issue }) => {
	const formattedDate = format(new Date(issue.date), 'EEEE d. MMMM yyyy', { locale: nb })
	const { snippet } = issue

	const marketSnippet = snippet
		.replace('[H]', '<span style="background-color: #d4a90f; color: white; padding: 0.2rem">')
		.replace('[/H]', '</span>')

	return (
		<EavisSearchIssueListItemStyled>
			<EavisSearchIssueListItemCTATrigger>
				<EavisSearchIssueListItemImageContainer>
					<EavisSearchIssueListItemImage src={issue.thumb} />
				</EavisSearchIssueListItemImageContainer>
				<EavisSearchIssueListItemTextContainer>
					<EavisSearchIssueListItemTextDate>{formattedDate}</EavisSearchIssueListItemTextDate>
					<EavisSearchIssueListItemTextSnippet>
						<div dangerouslySetInnerHTML={{ __html: marketSnippet }} />
					</EavisSearchIssueListItemTextSnippet>
					<EavisSearchReadThisPage>
						<EavisSearchReadThisPageButton href={GetIssuePageLink(issue.date, issue.page)}>
							Åpne »
						</EavisSearchReadThisPageButton>
					</EavisSearchReadThisPage>
				</EavisSearchIssueListItemTextContainer>
			</EavisSearchIssueListItemCTATrigger>
		</EavisSearchIssueListItemStyled>
	)
}

EavisSearchIssueListItem.propTypes = {
	issue: propTypes.shape({
		title: propTypes.string,
		date: propTypes.string,
		page: propTypes.number,
		thumb: propTypes.string,
		snippet: propTypes.string,
		catalog: propTypes.number,
	}).isRequired,
}

export default EavisSearchIssueListItem
