import React from 'react'
import propTypes from 'prop-types'
import { EavisSearchInfoContainer } from './search'

const EavisSearchInfo = ({ total, currentPage, noResults, q }) => {
	const pageLimit = 20
	let start = 1
	let end = currentPage * pageLimit

	if (currentPage > 1) {
		start = end - pageLimit + 1
	}

	if (end > total) {
		end = total
	}

	const message = noResults
		? `Fant dessverre ingen resultater for «${q}».`
		: `Viser resultat ${start} til ${end} av ${total}`

	return <EavisSearchInfoContainer>{message}</EavisSearchInfoContainer>
}

EavisSearchInfo.propTypes = {
	total: propTypes.number,
	currentPage: propTypes.number,
	noResults: propTypes.bool,
	q: propTypes.string,
}

EavisSearchInfo.defaultProps = {
	total: 0,
	currentPage: 1,
	noResults: false,
	q: '',
}

export default EavisSearchInfo
