import React, { useState } from 'react'
import { getYear } from 'date-fns'
import { SearchInputContainer, EavisSearchForm, EavisSearchButton } from './search'
import { GetIssuePageLink } from './functions'

const EavisSearchFormIssue = () => {
	const yearsList = []
	const daysList = []

	const curYear = getYear(new Date())

	const [year, setYear] = useState(curYear)
	const [month, setMonth] = useState('01')
	const [date, setDate] = useState('01')
	const handleYear = ({ target }) => setYear(target.value)
	const handleMonth = ({ target }) => setMonth(target.value)
	const handleDate = ({ target }) => setDate(target.value)

	const submit = () => {
		const dt = `${year}-${month}-${date}`
		const issueClickURL = GetIssuePageLink(dt, '')
		const url = window.location.origin.concat(issueClickURL)
		// Router.push(url) // @todo client side rendering
		window.location.href = url // for mvp we do it only serverside
	}

	for (let i = curYear; i >= 1868; i -= 1) {
		yearsList.push(
			<option key={`year${i}`} value={i}>
				{i}
			</option>,
		)
	}
	for (let i = 1; i <= 31; i += 1) {
		daysList.push(
			<option key={`day${i}`} value={i}>
				{i}
			</option>,
		)
	}
	return (
		<EavisSearchForm>
			<SearchInputContainer key="searchYear" className="selectInput">
				<label htmlFor="searchYear">
					År
					<select onChange={handleYear} id="searchYear">
						{yearsList}
					</select>
				</label>
			</SearchInputContainer>
			<SearchInputContainer key="searchMonth" className="selectInput">
				<label htmlFor="searchMonth">
					Måned
					<select onChange={handleMonth} id="searchMonth">
						<option key="month01" value="01">
							Januar
						</option>
						<option key="month02" value="02">
							Februar
						</option>
						<option key="month03" value="03">
							Mars
						</option>
						<option key="month04" value="04">
							April
						</option>
						<option key="month05" value="05">
							Mai
						</option>
						<option key="month06" value="06">
							Juni
						</option>
						<option key="month07" value="07">
							Juli
						</option>
						<option key="month08" value="08">
							August
						</option>
						<option key="month09" value="09">
							September
						</option>
						<option key="month10" value="10">
							Oktober
						</option>
						<option key="month11" value="11">
							November
						</option>
						<option key="month12" value="12">
							Desember
						</option>
					</select>
				</label>
			</SearchInputContainer>
			<SearchInputContainer key="searchDay" className="selectInput">
				<label htmlFor="searchDay">
					Dag (dato)
					<select onChange={handleDate} id="searchDay">
						{daysList}
					</select>
				</label>
			</SearchInputContainer>
			<EavisSearchButton onClick={submit} type="button">
				LES AVIS
			</EavisSearchButton>
		</EavisSearchForm>
	)
}

export default EavisSearchFormIssue
