import React from 'react'
import { Grid } from '@aller/shiny/src/atoms/Grid'
import { SearchArchiveRow, SearchArchiveItem } from './search'
import { IssueDate } from './index'

const EavisSearchArchiveInformation = () => {
	return (
		<Grid>
			<SearchArchiveRow>
				<SearchArchiveItem>
					<img alt="53 429 aviser" src="https://www.dagbladet.no/eavis/sok/images/newspaper.png" />
					<IssueDate>53 429 aviser</IssueDate>
					<span>
						Nå er de fleste utgavene av Dagbladets papiravis tilgjengelig – helt tilbake til 1869.
						Kun fantasien setter grenser for hva du kan søke etter i arkivet.
					</span>
				</SearchArchiveItem>
				<SearchArchiveItem>
					<img alt="Research" src="https://www.dagbladet.no/eavis/sok/images/snokeglass.png" />
					<IssueDate>Research</IssueDate>
					<span>
						Kanskje du leter etter et 10 år gammelt sitat fra en politiker? Eller vil du undersøke
						når en frase ble brukt for første gang?
					</span>
				</SearchArchiveItem>
				<SearchArchiveItem>
					<img alt="Nostalgi" src="https://www.dagbladet.no/eavis/sok/images/nostalgia.png" />
					<IssueDate>Nostalgi</IssueDate>
					<span>
						Du kan finne ut hvordan forsiden så ut dagen du ble født. Eller vil du kanskje mimre
						tilbake til '98, da Norge slo Brasil?
					</span>
				</SearchArchiveItem>
			</SearchArchiveRow>
		</Grid>
	)
}

export default EavisSearchArchiveInformation
