import React from 'react'
import propTypes from 'prop-types'
import { IssueDate } from './index'
import { EavisIssueWrapper, EavisIssueLink } from './latestBlock'
import { GetIssueLink, GetIssueListTitle } from './functions'

const EavisIssuesListItem = ({ imgSrc, date, type, title }) => {
	return (
		<EavisIssueWrapper className="eavis-issue-wrapper">
			<EavisIssueLink href={GetIssueLink(date, type)}>
				<img alt="" src={`https://${imgSrc}`} />
				<IssueDate>{GetIssueListTitle(type, date, title)}</IssueDate>
			</EavisIssueLink>
		</EavisIssueWrapper>
	)
}

EavisIssuesListItem.propTypes = {
	imgSrc: propTypes.string.isRequired,
	date: propTypes.string.isRequired,
	type: propTypes.string.isRequired,
	title: propTypes.string.isRequired,
}

export default EavisIssuesListItem
