import React from 'react'
import propTypes from 'prop-types'
import EavisIssuesListItem from './EavisIssuesListItem'

const EavisIssuesList = ({ issues }) => {
	return issues.map(issue => {
		return (
			<EavisIssuesListItem
				type={issue.type}
				title={issue.title}
				key={issue.catalog}
				imgSrc={issue.thumb}
				date={issue.date}
			/>
		)
	})
}

EavisIssuesList.propTypes = {
	issues: propTypes.arrayOf(propTypes.shape),
}

EavisIssuesList.defaultProps = {
	issues: [],
}

export default EavisIssuesList
