import React from 'react'
import propTypes from 'prop-types'
import { EavisPreviewOverlay } from './index'

const EavisImagePreview = ({ imgSrc, isOpen, closePreview }) => {
	return (
		<EavisPreviewOverlay className={isOpen ? 'open' : ''}>
			<img alt="preview" src={imgSrc} />
			<button onClick={closePreview} type="button" className="closeEavisImagePreview">
				+
			</button>
		</EavisPreviewOverlay>
	)
}

EavisImagePreview.propTypes = {
	imgSrc: propTypes.string.isRequired,
	isOpen: propTypes.bool,
	closePreview: propTypes.func.isRequired,
}

EavisImagePreview.defaultProps = {
	isOpen: false,
}

export default EavisImagePreview
