import React, { useState } from 'react'
import propTypes from 'prop-types'
import format from 'date-fns/format'
import nb from 'date-fns/locale/nb'
import {
	EavisTopIssueContainer,
	EavisTopIssueCurrentIssue,
	EavisCurrentIssueImage,
	EavisTopIssueSubscriptionInfo,
	EavisIssueImage,
	EavisIssueControls,
	EavisIssueImageShowPreview,
	EavisIssueShowDetails,
	EavisIssueDate,
	EavisXLargeHead,
	EavisCapitalize,
	EavisBoldTextDato,
} from './index'
import EavisDatoPages from './EavisDatoPages'
import LogInOut from './LogInOutBlock'
import EavisImagePreview from './EavisImagePreview'
import { GetIssuePageLink, GetPaywallURL } from './functions'

const EavisDatoTopIssue = ({ issue, loggedIn, type }) => {
	const date = new Date(issue.date)
	const issueDate = format(date, 'EEEE d. MMMM', { locale: nb })
	const issueClickLink = loggedIn ? GetIssuePageLink(date, 1, type) : GetPaywallURL()

	const [isOpen, setOpened] = useState(false)
	const showImgPreview = () => {
		setOpened(true)
	}
	const hideImgPreview = () => {
		setOpened(false)
	}

	return (
		<EavisTopIssueContainer>
			<EavisTopIssueCurrentIssue>
				<EavisCurrentIssueImage>
					<EavisIssueImage src={`https://${issue.thumb_medium}`} />
					<EavisIssueControls className="eavis-controls">
						<EavisIssueImageShowPreview onClick={showImgPreview}>
							Se stort bilde
						</EavisIssueImageShowPreview>
						<EavisIssueShowDetails href={issueClickLink}>Vis utgaven</EavisIssueShowDetails>
					</EavisIssueControls>
				</EavisCurrentIssueImage>
				<EavisIssueDate>
					<EavisBoldTextDato>Dagbladet eAvis er den digitale papirutgaven. </EavisBoldTextDato>
					Det er samme innhold og samme utseende. Er du ofte på reise, tilbringer tid utenlands,
					eller ønsker å lese avisen på jobben? Da er dette løsningen for deg! Den digitale avisen
					kan du lese når du vil og hvor du vil.
				</EavisIssueDate>
			</EavisTopIssueCurrentIssue>
			<EavisTopIssueSubscriptionInfo>
				<EavisXLargeHead>
					Dagbladet eAvis
					<br />
					<EavisCapitalize>{issueDate}</EavisCapitalize>
				</EavisXLargeHead>
				<LogInOut loggedIn={loggedIn} />
				<EavisDatoPages
					type={type}
					date={date}
					pages={issue.pages}
					catalog={issue.catalog}
					loggedIn={loggedIn}
				/>
			</EavisTopIssueSubscriptionInfo>
			<EavisImagePreview
				imgSrc={`https://${issue.thumb_medium}`}
				isOpen={isOpen}
				closePreview={hideImgPreview}
			/>
		</EavisTopIssueContainer>
	)
}

EavisDatoTopIssue.propTypes = {
	issue: propTypes.shape({
		date: propTypes.string.isRequired,
		thumb: propTypes.string.isRequired,
		thumb_medium: propTypes.string.isRequired,
		catalog: propTypes.number.isRequired,
		pages: propTypes.number.isRequired,
	}).isRequired,
	loggedIn: propTypes.bool.isRequired,
	type: propTypes.string.isRequired,
}

export default EavisDatoTopIssue
