import React from 'react'
import propTypes from 'prop-types'
import { format, getDay, getDaysInMonth, getMonth, getYear } from 'date-fns'
import { DayCell, CalendarDaysBlock, CalendarDayLink } from './calendar'

const EavisCalendarDaysContainer = ({ year, month }) => {
	const weekDayNumber = getDay(new Date(year, month))
	const totalDaysMonth = getDaysInMonth(new Date(year, month))
	const weeksToPrint = Math.ceil((weekDayNumber - 1 + totalDaysMonth) / 7)
	const daysToPrint = weeksToPrint * 7
	// if weekDayNumber === 0 -> Sunday, so 6 days preceeding
	const emptyDaysBefore = weekDayNumber === 0 ? 6 : weekDayNumber - 1
	const emptyDaysAfter = daysToPrint - (weekDayNumber - 1) - totalDaysMonth

	// week bar days
	const days = [
		<DayCell key="cDay-M" className="wBar">
			M
		</DayCell>,
		<DayCell key="cDay-Ti" className="wBar">
			T
		</DayCell>,
		<DayCell key="cDay-O" className="wBar">
			O
		</DayCell>,
		<DayCell key="cDay-To" className="wBar">
			T
		</DayCell>,
		<DayCell key="cDay-F" className="wBar">
			F
		</DayCell>,
		<DayCell key="cDay-L" className="wBar">
			L
		</DayCell>,
		<DayCell key="cDay-S" className="wBar">
			S
		</DayCell>,
	]
	const now = new Date()
	// preceeding empty days
	for (let i = 0; i < emptyDaysBefore; i += 1) {
		days.push(<DayCell key={`cDayEB${i}`} />)
	}
	// days of month
	for (let i = 1; i <= totalDaysMonth; i += 1) {
		const thisDay = new Date(year, month, i)
		if (thisDay > now) {
			// no links to future, just days
			days.push(<DayCell key={`cDay${i}`}>{i}</DayCell>)
			continue // eslint-disable-line no-continue
		}

		const hrefDate = format(thisDay, 'yyyy/MM/dd')
		const href = `https://www.dagbladet.no/eavis/dato/?d=${hrefDate}`
		days.push(
			<DayCell key={`cDay${i}`}>
				<CalendarDayLink href={href}>{i}</CalendarDayLink>
			</DayCell>,
		)
	}
	// tailing empty days
	for (let i = 0; i < emptyDaysAfter; i += 1) {
		days.push(<DayCell key={`cDayEA${i}`} />)
	}
	return <CalendarDaysBlock>{days}</CalendarDaysBlock>
}

EavisCalendarDaysContainer.propTypes = {
	year: propTypes.number,
	month: propTypes.number,
}

EavisCalendarDaysContainer.defaultProps = {
	year: getYear(new Date()),
	month: getMonth(new Date()),
}

export default EavisCalendarDaysContainer
